import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:intl_phone_field/intl_phone_field.dart';
import 'package:intl_phone_field/phone_number.dart';

import '../../../app_constants.dart';
import '../../../infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/styles/style.dart';

class CustomPhoneField extends StatelessWidget {
  final ValueChanged<PhoneNumber> onChanged;

  const CustomPhoneField({
    super.key,
    required this.onChanged,
  });

  @override
  Widget build(BuildContext context) {
    return IntlPhoneField(
      cursorWidth: 1,
      cursorColor: Style.textColor,
      disableLengthCheck: !AppConstants.isNumberLengthAlwaysSame,
      initialCountryCode: AppConstants.countryCodeISO,
      autovalidateMode: AppConstants.isNumberLengthAlwaysSame
          ? AutovalidateMode.onUserInteraction
          : AutovalidateMode.disabled,
      showCountryFlag: AppConstants.showFlag,
      showDropdownIcon: AppConstants.showArrowIcon,
      validator: (s) {
        if (AppConstants.isNumberLengthAlwaysSame &&
            (s?.isValidNumber() ?? true)) {
          return AppHelpers.getTranslation(TrKeys.phoneNumberIsNotValid);
        }
        return null;
      },
      style: Style.interNormal(size: 14, color: Style.black),
      onChanged: onChanged,
      dropdownTextStyle: Style.interNormal(size: 14, color: Style.black),
      keyboardType: TextInputType.phone,
      invalidNumberMessage:
      AppHelpers.getTranslation(TrKeys.phoneNumberIsNotValid),
      inputFormatters: [FilteringTextInputFormatter.digitsOnly],
      textAlignVertical: const TextAlignVertical(y: .2),
      decoration: InputDecoration(
        floatingLabelBehavior: FloatingLabelBehavior.always,
        fillColor: Style.black,
        filled: false,
        counterText: '',
        enabledBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(16),
          borderSide: const BorderSide(color: Style.icon),
        ),
        errorBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(16),
          borderSide: const BorderSide(color: Style.icon),
        ),
        border: OutlineInputBorder(
          borderRadius: BorderRadius.circular(16),
          borderSide: const BorderSide(color: Style.icon),
        ),
        disabledBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(16),
          borderSide: const BorderSide(color: Style.icon),
        ),
        focusedBorder: OutlineInputBorder(
          borderRadius: BorderRadius.circular(16),
          borderSide: const BorderSide(color: Style.icon),
        ),
      ),
    );
  }
}
